#pragma once

#include <infra/pod_agent/libs/config/config.pb.h>
#include <infra/pod_agent/libs/service_iface/service.h>

#include <infra/libs/logger/log_frame.h>

#include <contrib/libs/grpc/include/grpc++/grpc++.h>

#include <util/system/condvar.h>
#include <util/system/mutex.h>

namespace NInfra::NPodAgent {
/**
 *  Method Wait() waits for signal from Shutdown()
 *  Method Shutdown() signals to shutdown the service
 *  Method Stop() calls {Server_->Shutdown(); Server_->Wait();}
 *  Destructor calls {Stop();}
 */
class TGrpcService {
public:
    TGrpcService(const TGrpcServiceConfig& config, IService& service);

    void Start(TLogFramePtr logFrame);

    void Wait(TLogFramePtr logFrame);

    void Shutdown();

    static TString AddressFromConfig(const TGrpcServiceConfig& config_);

    ~TGrpcService();

private:
    void Stop();

private:
    class TImpl;

    TGrpcServiceConfig Config_;
    IService& Service_;

    THolder<TImpl> Impl_;
    THolder<grpc::ServerBuilder> ServerBuilder_;
    THolder<grpc::Server> Server_;

    TMutex ShutdownMutex_;
    TCondVar ShutdownCondvar_;

    bool ShutdownCalled_ = false;
};

} // namespace NInfra::NPodAgent
