#include "cached_unique_event_iterator.h"

#include <infra/libs/logger/hasher.h>
#include <infra/libs/logger/protos/events.ev.pb.h>

namespace NInfra::NPodAgent {

const TEvent* TCachedUniqueEventIterator::Next() {
    for (;;) {
        const TEvent* event = iter->Next();
        if (event) {
            ui32 hash = GetHash(event);
            if (!PastEvents_.insert(hash).second) {
                continue;
            }

            HashHistory_.push_back(hash);
        }

        return event;
    }
}

const TEvent* TCachedUniqueEventIterator::Prev() {
    if (!HashHistory_.empty()) {
        PastEvents_.erase(HashHistory_.back());
        HashHistory_.pop_back();
    }

    for (;;) {
        const TEvent* event = iter->Prev();
        if (event) {
            ui32 hash = GetHash(event);
            if (HashHistory_.empty() || hash != HashHistory_.back()) {
                continue;
            }
        }

        return event;
    }
}

ui32 TCachedUniqueEventIterator::GetHash(const TEvent* event) {
    TSimpleSharedPtr<NProtoBuf::Message> message = NProtoBuf::MessageFactory::generated_factory()->GetPrototype(event->GetProto()->GetDescriptor())->New();
    message->CopyFrom(*event->GetProto());
    TryToDropTickValue<NLogEvent::TBehaviourTreeTick>(message.Get());
    TryToDropTickValue<NLogEvent::TBehaviourTreeTickError>(message.Get());
    TryToDropTickValue<NLogEvent::TBehaviourTreeTickV2>(message.Get());

    TString data;
    google::protobuf::TextFormat::PrintToString(*message, &data);
    return Get32BitHash(data.data(), data.size());
}

} // namespace NInfra::NPodAgent
