#pragma once

#include <infra/libs/logger/event_iterator.h>

#include <util/generic/vector.h>

namespace NInfra::NPodAgent {

class TCachedUniqueEventIterator: public IEventIterator {
public:
    explicit TCachedUniqueEventIterator(const TIteratorOptions& options) {
        iter.Reset(new TCachedEventIterator(options));
    }

    const TEvent* Next() override;

    const TEvent* Prev() override;

private:
    template <typename TToCast>
    void TryToDropTickValue(NProtoBuf::Message* message) {
        TToCast* castedMessage = dynamic_cast<TToCast*>(message);
        if (castedMessage) {
            castedMessage->SetTick(0);
        }
    }

private:
    ui32 GetHash(const TEvent* event);

private:
    THolder<TCachedEventIterator> iter = nullptr;
    TSet<ui32> PastEvents_;
    TVector<ui32> HashHistory_;
};

} // namsapce NInfra::NPodAgent;
