#pragma once

#include <infra/libs/logger/log_printer.h>
#include <infra/libs/logger/protos/events.ev.pb.h>

#include <contrib/libs/termbox/src/termbox.h>

namespace NInfra::NPodAgent {

class TTermBoxWorker : private TNonCopyable {
public:
    TTermBoxWorker() {
        Y_ENSURE(tb_init() == 0, "failed to initialize termbox");
    }

    ~TTermBoxWorker() {
        tb_shutdown();
    }

    void RenderString(const TString& string) {
        CurrentString_ = string;
        Draw();
    }

    void IncreaseOffset(i32 dx, i32 dy) {
        XOffset_ = Max(0, XOffset_ + dx);
        YOffset_ = Max(0, YOffset_ + dy);
        Draw();
    }

private:
    void Draw();

    TString CurrentString_;
    i32 XOffset_{0};
    i32 YOffset_{0};
};

TString RenderTree(const NLogEvent::TBehaviourTreeTickV2& tree);

TString RenderEvent(const TEvent* event, TEvent::TEventContext& context);

void StartInteractiveLog(const TIteratorOptions& options, TEvent::TEventContext context, bool uniqueOnly);

} // namespace NInfra::NPodAgent
