#include "interactive_log.h"

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTestInteractiveLog {

Y_UNIT_TEST_SUITE(InteractiveLogSuite) {

Y_UNIT_TEST(RenderTree) {
    NLogEvent::TBehaviourTreeTickV2 tree;
    tree.SetTreeId("TreeId");
    tree.SetTick(42);
    auto root = tree.mutable_root();
    root->SetTitle("Root:Tree_title:");
    root->SetNodeType(NLogEvent::TBehaviourTreeTickV2::ENodeType_MEM_SEQUENCE);
    root->mutable_success()->SetStatus(NLogEvent::TBehaviourTreeTickV2::ENodeStatus_SUCCESS);
    root->mutable_success()->SetMessage("root message");
    {
        auto child = root->add_children();
        child->SetTitle("Child_0_title");
        child->SetNodeType(NLogEvent::TBehaviourTreeTickV2::ENodeType_MOCK);
        child->mutable_success()->SetStatus(NLogEvent::TBehaviourTreeTickV2::ENodeStatus_FAILURE);
        child->mutable_success()->SetMessage("child 0 message");
    }
    {
        auto child = root->add_children();
        child->SetTitle("Child_1_title");
        child->SetNodeType(NLogEvent::TBehaviourTreeTickV2::ENodeType_MOCK);
        child->mutable_error()->SetMessage("child 1 message");
    }

    TString rendered = RenderTree(tree);
    TString target = TString("TreeId: TreeId")
        + "\nTick: 42"
        + "\nRR> Root:Tree_title:MemSequence [SUCCESS : root message]"
        + "\n  --> Mock(Child_0_title) [FAILURE : child 0 message]"
        + "\n  --> Mock(Child_1_title) [ERROR : child 1 message]";
    UNIT_ASSERT_STRINGS_EQUAL(target, rendered);
}

}

} // namespace NInfra::NPodAgent::NTestInteractiveLog
