#pragma once

#include "ip_client_types.h"

#include <infra/libs/outcome/result.h>

#include <util/generic/ptr.h>
#include <util/generic/vector.h>

namespace NInfra::NPodAgent {

class IIpClient;
using TIpClientPtr = TIntrusivePtr<IIpClient>;

class IIpClient: public TAtomicRefCount<IIpClient> {
public:
    virtual ~IIpClient() = default;

    virtual TExpected<void, TIpClientError> AddAddress(const TString& device, const TIpDescription& ip) = 0;
    virtual TExpected<void, TIpClientError> RemoveAddress(const TString& device, const TIpDescription& ip) = 0;

    virtual TExpected<TVector<TIpDescription>, TIpClientError> ListAddress(const TString& device) = 0;
};

} // namespace NInfra::NPodAgent
