#pragma once

#include <util/generic/string.h>
#include <util/string/cast.h>
#include <util/string/builder.h>

namespace NInfra::NPodAgent {

enum class EIpClientError: ui8 {
    Unspecified                   = 0  /* "unspecifed" */,
    DeviceError                   = 1  /* "device error" */,
    Ip6ParseError                 = 2  /* "ip6 parse error" */,

    SocketOpenError               = 3  /* "socket open error" */,
    SocketBindError               = 4  /* "socket bind error" */,
    SocketSendToError             = 5  /* "socket sendto error" */,
    SocketRecvFromError           = 6  /* "socket recvfrom error" */,
    SocketCallbackRunError        = 7  /* "socket callback run error" */,
    SocketGetPortIdError          = 8  /* "socket get port id error" */,
};

struct TIpClientError {
    TIpClientError(
        EIpClientError errnoValue
        , const TString& message
    )
        : Errno(errnoValue)
        , Message(message)
    {}

    const EIpClientError Errno = EIpClientError::Unspecified;
    const TString Message = "";
};

struct TIpDescription {
    TIpDescription(
        const TString& ip6
        , ui32 subnet
    )
        : Ip6(ip6)
        , Subnet(subnet)
    {}

    TString ToString() const {
        return TStringBuilder()
            << Ip6
            << "/"
            << Subnet;
    }

    TString Ip6 = "";
    ui32 Subnet = 0;
};

} // namespace NInfra::NPodAgent

inline TString ToString(const NInfra::NPodAgent::TIpClientError& error) {
    return TStringBuilder()
        << ToString(error.Errno)
        << " : "
        << error.Message;
}
