#pragma once

#include "client.h"

namespace NInfra::NPodAgent {

class TMockIpClient: public IIpClient {
public:
    virtual ~TMockIpClient() = default;

    virtual TExpected<void, TIpClientError> AddAddress(const TString& /* device */, const TIpDescription& /* ip */) override {
        return TExpected<void, TIpClientError>::DefaultSuccess();
    }
    virtual TExpected<void, TIpClientError> RemoveAddress(const TString& /* device */, const TIpDescription& /* ip */) override {
        return TExpected<void, TIpClientError>::DefaultSuccess();
    }

    virtual TExpected<TVector<TIpDescription>, TIpClientError> ListAddress(const TString& /* device */) override {
        return TExpected<TVector<TIpDescription>, TIpClientError>::DefaultSuccess();
    }
};

} // namespace NInfra::NPodAgent
