#pragma once

#include "client.h"

namespace NInfra::NPodAgent {

class TSimpleIpClient;
using TSimpleIpClientPtr = TIntrusivePtr<TSimpleIpClient>;

class TSimpleIpClient: public IIpClient {
public:
    virtual ~TSimpleIpClient() = default;

    virtual TExpected<void, TIpClientError> AddAddress(const TString& device, const TIpDescription& ip) override;
    virtual TExpected<void, TIpClientError> RemoveAddress(const TString& device, const TIpDescription& ip) override;

    virtual TExpected<TVector<TIpDescription>, TIpClientError> ListAddress(const TString& device) override;
};

} // namespace NInfra::NPodAgent
