#include "multi_unistat.h"

#include <util/generic/yexception.h>

namespace NInfra::NPodAgent {

NUnistat::IHolePtr TMultiUnistat::DrillFloatHole(
    const ESignalNamespace signalNamespace
    , const TString& name
    , const TString& description
    , const TString& suffix
    , NUnistat::TPriority priority
    , NUnistat::TStartValue startValue
    , EAggregationType type
    , bool alwaysVisible
) {
    return GetUnistatInstance(signalNamespace)->DrillFloatHole(
        name
        , description
        , suffix
        , priority
        , startValue
        , type
        , alwaysVisible
    );
}

NUnistat::IHolePtr TMultiUnistat::DrillFloatHole(
    const ESignalNamespace signalNamespace
    , const TString& name
    , const TString& suffix
    , NUnistat::TPriority priority
    , NUnistat::TStartValue startValue
    , EAggregationType type
    , bool alwaysVisible
) {
    return GetUnistatInstance(signalNamespace)->DrillFloatHole(
        name
        , suffix
        , priority
        , startValue
        , type
        , alwaysVisible
    );
}

NUnistat::IHolePtr TMultiUnistat::DrillHistogramHole(
    const ESignalNamespace signalNamespace
    , const TString& name
    , const TString& description
    , const TString& suffix
    , NUnistat::TPriority priority
    , const NUnistat::TIntervals& intervals
    , EAggregationType type
    , bool alwaysVisible
) {
    return GetUnistatInstance(signalNamespace)->DrillHistogramHole(
        name
        , description
        , suffix
        , priority
        , intervals
        , type
        , alwaysVisible
    );
}

NUnistat::IHolePtr TMultiUnistat::DrillHistogramHole(
    const ESignalNamespace signalNamespace
    , const TString& name
    , const TString& suffix
    , NUnistat::TPriority priority
    , const NUnistat::TIntervals& intervals
    , EAggregationType type
    , bool alwaysVisible
) {
    return GetUnistatInstance(signalNamespace)->DrillHistogramHole(
        name
        , suffix
        , priority
        , intervals
        , type
        , alwaysVisible
    );
}

void TMultiUnistat::Reset(const ESignalNamespace signalNamespace) {
    return GetUnistatInstance(signalNamespace)->Reset();
}

TVector<TString> TMultiUnistat::GetHolenames(const ESignalNamespace signalNamespace) const {
    return GetUnistatInstance(signalNamespace)->GetHolenames();
}

void TMultiUnistat::ResetAll() {
    for (auto& unistatPair : Unistats_) {
        unistatPair.second->Reset();
    }
}

void TMultiUnistat::ResetAllSignals() {
    for (auto& unistatPair : Unistats_) {
        unistatPair.second->ResetSignals();
    }
}

void TMultiUnistat::ResetSignals(const ESignalNamespace signalNamespace) {
    GetUnistatInstance(signalNamespace)->ResetSignals();
}

bool TMultiUnistat::EraseHole(const ESignalNamespace signalNamespace, const TString& name) {
    return GetUnistatInstance(signalNamespace)->EraseHole(name);
}

TString TMultiUnistat::CreateJsonDump(const ESignalNamespace signalNamespace, int level, bool allHoles) const {
    return GetUnistatInstance(signalNamespace)->CreateJsonDump(level, allHoles);
}

TString TMultiUnistat::CreateInfoDump(const ESignalNamespace signalNamespace, int level) const {
    return GetUnistatInstance(signalNamespace)->CreateInfoDump(level);
}

const TUnistatPtr TMultiUnistat::GetUnistatInstance(ESignalNamespace signalNamespace) const {
    auto unistatInstance = Unistats_.FindPtr(signalNamespace);
    Y_ENSURE(unistatInstance, "Unistat not found for requested signalNamespace: '" <<  signalNamespace << "'");
    return *unistatInstance;
}

void TMultiUnistat::ExportToProto(const ESignalNamespace signalNamespace, TInstanceStats& stats, int level) const {
    return GetUnistatInstance(signalNamespace)->ExportToProto(stats, level);
};

} // namespace NInfra::NPodAgent
