#pragma once

#include "client.h"

namespace NInfra::NPodAgent {

class TMockNetworkClient: public INetworkClient {
public:
    virtual ~TMockNetworkClient() = default;

    virtual TExpected<TString, TNetworkClientError> GetLocalHostName() override {
        return TExpected<TString, TNetworkClientError>::DefaultSuccess();
    }

    virtual TExpected<void, TNetworkClientError> CheckAndAddHttpRequest(
        const TString& /* requestKey */
        , const TString& /* requestHash */
        , const TString& /* additionalInfo */
        , const TString& /* host */
        , ui32 /* port */
        , const TString& /* path */
        , TDuration /* timeout */
    ) override {
        return TExpected<void, TNetworkClientError>::DefaultSuccess();
    }

    virtual TExpected<void, TNetworkClientError> CheckAndAddTcpRequest(
        const TString& /* requestKey */
        , const TString& /* requestHash */
        , const TString& /* additionalInfo */
        , ui32 /* port */
        , TDuration /* timeout */
    ) override {
        return TExpected<void, TNetworkClientError>::DefaultSuccess();
    }

    virtual TExpected<void, TNetworkClientError> RemoveRequest(const TString& /* requestKey */) override {
        return TExpected<void, TNetworkClientError>::DefaultSuccess();
    }
    virtual TExpected<TVector<TRequestPublicInfo>, TNetworkClientError> ListRequests() const override {
        return TExpected<TVector<TRequestPublicInfo>, TNetworkClientError>::DefaultSuccess();
    }

    virtual TExpected<ERequestState, TNetworkClientError> GetRequestState(const TString& /* requestKey */, const TString& /* requestHash */) override {
        return TExpected<ERequestState, TNetworkClientError>::DefaultSuccess();
    }

    virtual TExpected<TString, TNetworkClientError> GetRequestDescription(const TString& /* requestKey */, const TString& /* requestHash */) override {
        return TExpected<TString, TNetworkClientError>::DefaultSuccess();
    }
    
    virtual TExpected<TString, TNetworkClientError> GetAndRemoveRequestResponse(const TString& /* requestKey */, const TString& /* requestHash */) override {
        return TExpected<TString, TNetworkClientError>::DefaultSuccess();
    }
};

} // namespace NInfra::NPodAgent
