#pragma once

#include "network_request.h"

namespace NInfra::NPodAgent {

class TMockNetworkRequest: public INetworkRequest {
public:
    virtual ~TMockNetworkRequest() = default;

    virtual TExpected<void, TNetworkClientError> Init() override {
        return TExpected<void, TNetworkClientError>::DefaultSuccess();
    }

    virtual bool Execute(const TDuration& /*timeout*/) override {
        return false;
    }
    virtual void Cancel() override { }
    
    virtual bool IsError() const override {
        return false;
    }
    
    virtual TString GetErrorText() const override {
        return "";
    }
    
    virtual TString Data() const override {
        return "";
    }
    
    virtual TString Description() const override {
        return "";
    }
};

} // namespace NInfra::NPodAgent
