#pragma once

#include <util/generic/string.h>
#include <util/string/cast.h>
#include <util/string/builder.h>

namespace NInfra::NPodAgent {

enum class ENetworkClientError: ui8 {
    Unspecified                   = 0  /* "unspecifed" */,
    RequestDoesNotExist           = 1  /* "request_does_not_exist" */,
    RequestAlreadyExist           = 2  /* "request_already_exist" */,
    RequestHashMismatched         = 3  /* "request_hash_mismatched" */,
    RequestIncompleted            = 4  /* "request_incompleted" */,
    RequestTimeout                = 5  /* "request_timeout" */,
    RequestError                  = 6  /* "request_error" */,
    GetLocalHostNameError         = 7  /* "get_local_hostname_error" */,
};

struct TNetworkClientError {
    TNetworkClientError(
        ENetworkClientError errnoValue
        , const TString& message
    )
        : Errno(errnoValue)
        , Message(message)
    {}

    const ENetworkClientError Errno = ENetworkClientError::Unspecified;
    const TString Message = "";
};

} // namespace NInfra::NPodAgent


inline TString ToString(const NInfra::NPodAgent::TNetworkClientError& error) {
    return TStringBuilder()
        << ToString(error.Errno)
        << " : "
        << error.Message;
}
