#pragma once

#include "network_request.h"

#include <library/cpp/neh/neh.h>

namespace NInfra::NPodAgent {

class TNetworkHttpRequest;
using TNetworkHttpRequestPtr = TIntrusivePtr<TNetworkHttpRequest>;

class TNetworkHttpRequest: public INetworkRequest {
public:
    TNetworkHttpRequest(
        const TString& host
        , ui32 port
        , const TString& path
    );
    virtual TExpected<void, TNetworkClientError> Init() override;
    virtual bool Execute(const TDuration& timeout) override;
    virtual void Cancel() override;
    virtual bool IsError() const override;
    virtual TString GetErrorText() const override;
    virtual TString Data() const override;
    virtual TString Description() const override;

private:
    TString MakeAddress() const;

private:
    const TString Host_;
    const ui32 Port_;
    const TString Path_;
    const TString Address_;
    NNeh::THandleRef Request_;
    NNeh::TResponseRef Response_;
};

} // namespace NInfra::NPodAgent
