#pragma once

#include "network_client_types.h"

#include <infra/libs/outcome/result.h>

#include <util/datetime/base.h>
#include <library/cpp/deprecated/atomic/atomic.h>

namespace NInfra::NPodAgent {

class INetworkRequest;
using TNetworkRequestPtr = TIntrusivePtr<INetworkRequest>;

class INetworkRequest: public TAtomicRefCount<INetworkRequest> {
public:
    virtual ~INetworkRequest() = default;

    virtual TExpected<void, TNetworkClientError> Init() = 0;
    virtual bool Execute(const TDuration& timeout) = 0;
    virtual void Cancel() = 0;
    virtual bool IsError() const = 0;
    virtual TString GetErrorText() const = 0;
    virtual TString Data() const = 0;
    virtual TString Description() const = 0;

protected:
    TAtomic Cancelled_ = 0;
};

} // namespace NInfra::NPodAgent
