#include "network_tcp_request.h"
#include "network_http_request.h"

#include <library/cpp/testing/common/network.h>
#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

namespace NInfra::NPodAgent::NNetworkRequestTest {

const TDuration MAX_EXECUTION_TIME = TDuration::MilliSeconds(500);

Y_UNIT_TEST_SUITE(NetworkRequestTest) {

Y_UNIT_TEST(TestExecuteAndCancelTcpRequest) {
    NTesting::TPortHolder port = NTesting::GetFreePort();

    TNetworkRequestPtr request = MakeIntrusive<TNetworkTcpRequest>(port);
    request->Init();

    UNIT_ASSERT(request->Execute(MAX_EXECUTION_TIME));
    UNIT_ASSERT(request->IsError());
    TString error = TStringBuilder() << "TCP request to [::1]:" << port << ": Connection refused";
    UNIT_ASSERT_EQUAL_C(request->GetErrorText(), error, request->GetErrorText());

    request->Cancel();
    UNIT_ASSERT(request->IsError());
    TString cancelError = TStringBuilder() << "TCP request to [::1]:" << port << ": Connection cancelled";
    UNIT_ASSERT_EQUAL_C(request->GetErrorText(), cancelError, request->GetErrorText());

    UNIT_ASSERT_EQUAL_C(request->Data(), "", request->Data());
}

Y_UNIT_TEST(TestExecuteAndCancelHttpRequest) {
    NTesting::TPortHolder port = NTesting::GetFreePort();
    const TString host = "localhost";
    const TString path = "";

    TNetworkRequestPtr request = MakeIntrusive<TNetworkHttpRequest>(host, port, path);
    request->Init();

    UNIT_ASSERT(request->Execute(MAX_EXECUTION_TIME));
    UNIT_ASSERT(request->IsError());
    TString error = TStringBuilder() << "HTTP request to http2://" << host << ":" << port << "/" << path << ": Connection refused";
    UNIT_ASSERT_EQUAL_C(request->GetErrorText(), error, request->GetErrorText());

    request->Cancel();
    UNIT_ASSERT(request->IsError());
    TString cancelError = TStringBuilder() << "HTTP request to http2://" << host << ":" << port << "/" << path << ": Connection cancelled";
    UNIT_ASSERT_EQUAL_C(request->GetErrorText(), cancelError, request->GetErrorText());
}

}

} // namespace NInfra::NPodAgent::NNetworkRequestTest
