#include "network_tcp_request.h"

namespace NInfra::NPodAgent {

const TDuration TNetworkTcpRequest::CONNECTION_PAUSE_PERIOD = TDuration::MilliSeconds(50);

TNetworkTcpRequest::TNetworkTcpRequest(ui32 port)
    : Addr_("::1", port)
    , ConnectSocket_(socket(AF_INET6, SOCK_STREAM | SOCK_NONBLOCK, 0))
    , ConnectResult_(0)
{}

TExpected<void, TNetworkClientError> TNetworkTcpRequest::Init() {
    // nothing to do
    return TExpected<void, TNetworkClientError>::DefaultSuccess();
}

bool TNetworkTcpRequest::Execute(const TDuration& timeout) {
    TInstant startTime_ = TInstant::Now();
    while (!AtomicGet(Cancelled_) && TInstant::Now() - startTime_ < timeout) {
        ConnectResult_ = ConnectSocket_.Connect(&Addr_);
        if (-ConnectResult_ != EINPROGRESS && -ConnectResult_ != EALREADY) {
            return true;
        }
        Sleep(CONNECTION_PAUSE_PERIOD);
    }
    return false;
}

void TNetworkTcpRequest::Cancel() {
    AtomicSet(Cancelled_, 1);
}

bool TNetworkTcpRequest::IsError() const {
    return AtomicGet(Cancelled_) || ConnectResult_;
}

TString TNetworkTcpRequest::GetErrorText() const {
    if (AtomicGet(Cancelled_) != 0) {
        return TStringBuilder() << Description() << ": Connection cancelled";
    }
    return TStringBuilder() << Description() << ": " << strerror(-ConnectResult_);
}

TString TNetworkTcpRequest::Data() const {
    return "";
}

TString TNetworkTcpRequest::Description() const {
    return TStringBuilder() << "TCP request to " << Addr_.ToString();
}

} // namespace NInfra::NPodAgent
