#pragma once

#include "network_request.h"

#include <util/network/sock.h>
#include <util/datetime/base.h>

namespace NInfra::NPodAgent {

class TNetworkTcpRequest;
using TNetworkTcpRequestPtr = TIntrusivePtr<TNetworkTcpRequest>;

class TNetworkTcpRequest: public INetworkRequest {
public:
    TNetworkTcpRequest(ui32 port);
    virtual TExpected<void, TNetworkClientError> Init() override;
    virtual bool Execute(const TDuration& timeout) override;
    virtual void Cancel() override;
    virtual bool IsError() const override;
    virtual TString GetErrorText() const override;
    virtual TString Data() const override;
    virtual TString Description() const override;

private:
    static const TDuration CONNECTION_PAUSE_PERIOD;

    TSockAddrInet6 Addr_;
    TInet6StreamSocket ConnectSocket_;
    i32 ConnectResult_;
};

} // namespace NInfra::NPodAgent
