#pragma once

#include <google/protobuf/message.h>

#include <library/cpp/protobuf/json/json2proto.h>
#include <library/cpp/protobuf/json/proto2json.h>

#include <util/folder/dirut.h>
#include <util/generic/string.h>
#include <util/stream/file.h>

namespace NInfra::NPodAgent::NCacheFile {

template<typename TProto>
TProto LoadFromFileJson(const TString& filePath) {
    TString json = TUnbufferedFileInput(filePath).ReadAll();
    return NProtobufJson::Json2Proto<TProto>(json);
}

template<typename TProto>
TProto LoadFromFileBin(const TString& filePath) {
    TProto result;
    TUnbufferedFileInput fileInput(filePath);
    Y_ENSURE(result.ParseFromArcadiaStream(&fileInput), "Fail to parse proto from file");
    return result;
}

// Using json for persisting floats is a bad idea
// Use binary format instead
template<typename TProto>
void SaveToFileJson(const TString& filePath, const TProto& proto) {
    TString json;
    NProtobufJson::TProto2JsonConfig config = {};
    config.FormatOutput = true;
    NProtobufJson::Proto2Json(proto, json, config);

    TString dir = GetDirName(filePath);
    if (!NFs::Exists(dir)) {
        NFs::MakeDirectoryRecursive(dir);
    }
    TUnbufferedFileOutput fileOutput(filePath);
    fileOutput.Write(json);
}

template<typename TProto>
void SaveToFileBin(const TString& filePath, const TProto& proto) {
    TString dir = GetDirName(filePath);
    if (!NFs::Exists(dir)) {
        NFs::MakeDirectoryRecursive(dir);
    }
    TUnbufferedFileOutput fileOutput(filePath);
    Y_ENSURE(proto.SerializeToArcadiaStream(&fileOutput), "Fail to save proto to file");
}

} // namespace NInfra::NPodAgent::NCacheFile
