#pragma once

#include <infra/pod_agent/libs/pod_agent/garbage_collector_job/garbage_collector_job.h>
#include <infra/pod_agent/libs/pod_agent/period_job_worker/period_job_worker.h>
#include <infra/pod_agent/libs/pod_agent/trees_generators/trees_generator.h>

namespace NInfra::NPodAgent {

static const TString HIDDEN_SECRET_ATTRIBUTE_VALUE = "<..>";
static const TString HIDDEN_SECRET_ATTRIBUTE_ID_PREFIX = "DO_NOT_USE_THIS_SPEC_FOR_UPDATE_SECRET_VALUES_ARE_REMOVED_";

// Start, Shutdown and UpdateSpec are thread safe
// Reason: Parallel work with http and grpc

class TCoreService {
public:
    TCoreService(
        TLogger& logger
        , TLogger& treeTraceLogger
        , TLogger& logsTransmitterJobWorkerEventsLogger
        , const TConfig& config
        , const TString& dom0PodRoot
        , const TMap<TString, TString>& virtualDisksToPlace
        , const TMap<TString, TString>& placesToDownloadVolumePath
    );

    void Start();

    void Wait();

    void Shutdown();

    API::TPodAgentStatus UpdatePodAgentRequest(const API::TPodAgentRequest& spec);

    API::TPodAgentStatus GetPodAgentStatus() const;

    TString PodAttributesJson() const;

    TString PodStatusJson() const;

    void UpdateConditionSensors();

private:
    void TryUpdateSpecFromSavePath(TLogFramePtr logFrame);
    void SaveSpecToSavePath(const API::TPodAgentRequest& spec, TLogFramePtr logFrame);
    API::TPodAgentRequest HideSecrets(const API::TPodAgentRequest& spec);
    API::TPodAgentRequest PatchPodDynamicAttributes(const API::TPodAgentRequest& spec);


private:
    TLogger& Logger_;
    TLogger& TreeTraceLogger_;
    TLogger& LogsTransmitterJobWorkerEventsLogger_;

    const TConfig Config_;
    const TString Dom0PodRoot_;
    const TMap<TString, TString> VirtualDisksToPlace_;
    const TMap<TString, TString> PlacesToDownloadVolumePath_;

    TMutex Mutex_;
    TMutex UpdateSpecMutex_;

    API::TPodAgentRequest CurrentRequest_;

    TAtomicSharedPtr<IThreadPool> TreesWorkersMtpQueue_;

    TMtpPeriodTickerPtr BehaviorTicker_;

    THolder<TPeriodJobWorker> PeriodJobWorker_;
    TGarbageCollectorJobPtr GarbageCollectorJob_;

    THolder<TTreesGenerator> TreesGenerator_;
};

} // namespace NInfra::NPodAgent
