#pragma once

#include <infra/libs/outcome/result.h>
#include <infra/pod_agent/libs/push_client/utils/push_client_types.h>
#include <util/generic/maybe.h>

namespace NInfra::NPodAgent {

class IFileStreamRotated;

using TFileStreamRotatedPtr = TIntrusivePtr<IFileStreamRotated>;

class IFileStreamRotated: public TAtomicRefCount<IFileStreamRotated> {
public:
    virtual TExpected<TString, TPushClientError> Read(ui64 offset, ui64 size) = 0;
    //returns size of rotated part
    virtual TExpected<ui64, TPushClientError> Rotate() = 0;
    virtual TExpected<ui64, TPushClientError> GetFileSize() const = 0;
    virtual TString GetFilePath() const = 0;
    virtual TExpected<ui32, TPushClientError> TryClearFile() = 0;

    //became invalid in a case of error in TMaybe
    virtual TMaybe<TPushClientError> HasBecomeInvalid() = 0;
    virtual ~IFileStreamRotated() = default;
};

} //namespace NInfra::NPodAgent
