#include "file_stream_rotated_factory.h"
#include "file_stream_rotated_impl.h"
#include "file_stream_rotated_mock_invalid.h"

namespace NInfra::NPodAgent {

TFileStreamRotatedFactory::TFileStreamRotatedFactory(ui32 maxLogsFileSize, double minPortionToCut, blksize_t fileSystemBlockSize, TFileSystemUtilsPtr fileSystemUtils)
    : MaxLogsFileSize_(maxLogsFileSize)
    , MinPortionToCut_(minPortionToCut)
    , FileSystemBlockSize_(fileSystemBlockSize)
    , FileSystemUtils_(fileSystemUtils)
{}

TFileStreamRotatedPtr TFileStreamRotatedFactory::CreateFileStreamRotatedImpl(const TString& path) const {
    return new TFileStreamRotatedImpl(path, MinPortionToCut_, MaxLogsFileSize_, FileSystemBlockSize_, FileSystemUtils_);
}

TFileStreamRotatedPtr TFileStreamRotatedFactory::Create(const TString& path) {
    try {
        return CreateFileStreamRotatedImpl(path);
    } catch(const yexception&) {
        return new TMockInvalidFileStreamRotated(path, TPushClientError{EPushClientError::FileStreamCreationError, CurrentExceptionMessage()});
    }
}

} //namespace NInfra::NPodAgent
