#pragma once

#include "file_stream_rotated_impl.h"

namespace NInfra::NPodAgent {

class TFileStreamRotatedFactory;

using TFileStreamRotatedFactoryPtr = TIntrusivePtr<TFileStreamRotatedFactory>;

class TFileStreamRotatedFactory: public TAtomicRefCount<TFileStreamRotatedFactory> {
public:
    TFileStreamRotatedFactory() = default;
    TFileStreamRotatedFactory(ui32 maxLogsFileSize, double minPortionToCut, blksize_t fileSystemBlockSize, TFileSystemUtilsPtr fileSystemUtils);
    virtual TFileStreamRotatedPtr Create(const TString& path);
    virtual ~TFileStreamRotatedFactory() = default;

private:
    virtual TFileStreamRotatedPtr CreateFileStreamRotatedImpl(const TString& path) const;

private:
    ui32 MaxLogsFileSize_;
    double MinPortionToCut_;
    blksize_t FileSystemBlockSize_;
    TFileSystemUtilsPtr FileSystemUtils_;
};

} //namespace NInfra::NPodAgent
