#include "file_stream_rotated_factory.h"

#include <infra/pod_agent/libs/pod_agent/logs_transmitter/utils/file_system_utils_mock.h>
#include <library/cpp/testing/unittest/registar.h>
#include <sys/stat.h>
#include <util/system/fs.h>

namespace NInfra::NPodAgent::NFileStreamRotatedFactoryTest {

static constexpr const double defaultMinPortionToCut = 0.2;
static const ui32 defaultMaxLogsFileSize = 1000;
static const blksize_t defaultFileSystemBlockSize = 100;
static const TString defaultFileName = "filename";

Y_UNIT_TEST_SUITE(FileStreamRotatedFactorySuite) {

Y_UNIT_TEST(CreateValidFileStreamTest) {
    TFileStreamRotatedFactoryPtr factory = new TFileStreamRotatedFactory(defaultMaxLogsFileSize, defaultMinPortionToCut, defaultFileSystemBlockSize, new TMockFileSystemUtils);    
    TFileStreamRotatedPtr stream = factory->Create(defaultFileName);
    UNIT_ASSERT_EQUAL(stream->HasBecomeInvalid().Defined(), false);

    NFs::Remove(defaultFileName);
}

Y_UNIT_TEST(CreateInvalidFileStreamTest) {
    struct TTestFileStreamRotatedFactory: public TFileStreamRotatedFactory {
        TTestFileStreamRotatedFactory(ui32 maxLogsFileSize, double minPortionToCut, blksize_t fileSystemBlockSize, TFileSystemUtilsPtr fileSystemUtils)
            : TFileStreamRotatedFactory(maxLogsFileSize, minPortionToCut, fileSystemBlockSize, fileSystemUtils)
        {}

        TFileStreamRotatedPtr CreateFileStreamRotatedImpl(const TString&) const override {
            throw yexception() << "file stream creation error";
        }
    };

    TFileStreamRotatedFactoryPtr factory = new TTestFileStreamRotatedFactory(defaultMaxLogsFileSize, defaultMinPortionToCut, defaultFileSystemBlockSize, new TMockFileSystemUtils);    
    TFileStreamRotatedPtr stream = factory->Create(defaultFileName);
    UNIT_ASSERT_EQUAL(stream->HasBecomeInvalid().Defined(), true);
        
    TPushClientError cause = *(stream->HasBecomeInvalid());

    UNIT_ASSERT_EQUAL(cause.Errno, EPushClientError::FileStreamCreationError);
    UNIT_ASSERT_STRING_CONTAINS(cause.Message, "file stream creation error");
}

}

}
