#pragma once

#include "file_stream_rotated.h"

#include <infra/pod_agent/libs/pod_agent/logs_transmitter/utils/file_system_utils.h>
#include <util/stream/file.h>

namespace NInfra::NPodAgent {

class TFileStreamRotatedImpl: public IFileStreamRotated {
public:
    TFileStreamRotatedImpl(
        const TString& filePath
        , double minPortionToCut
        , ui32 maxLogsFileSize
        , blksize_t fileSystemBlockSize
        , TFileSystemUtilsPtr fileSystemUtils
    );

    TExpected<TString, TPushClientError> Read(ui64 offset, ui64 size) override;
    TExpected<ui64, TPushClientError> Rotate() override;
    TExpected<ui64, TPushClientError> GetFileSize() const override;
    TString GetFilePath() const override;
    TExpected<ui32, TPushClientError> TryClearFile() override;
    TMaybe<TPushClientError> HasBecomeInvalid() override;

private:
    TMaybe<TPushClientError> IsInvalid();

private:
    bool MarkedInvalid_;
    TString FilePath_;
    TFile File_;
    TUnbufferedFileInput Stream_;
    double MinPortionToCut_;
    ui32 MaxLogsFileSize_;
    blksize_t FileSystemBlockSize_;
    time_t LastCachedModificationTime_;
    TFileSystemUtilsPtr FileSystemUtils_;
    TExpected<ino_t, TPushClientError> InitialInodeGetResult_;
};

} //namespace NInfra::NPodAgent
