#pragma once

#include "file_stream_rotated.h"

namespace NInfra::NPodAgent {

class TMockFileStreamRotated: public IFileStreamRotated {
public:
    virtual TExpected<TString, TPushClientError> Read(ui64, ui64) override { return TExpected<TString, TPushClientError>::DefaultSuccess(); }
    virtual TExpected<ui64, TPushClientError> Rotate() override { return TExpected<ui64, TPushClientError>::DefaultSuccess(); }
    virtual TExpected<ui64, TPushClientError> GetFileSize() const override { return 3; }
    virtual TString GetFilePath() const override { return ""; };
    virtual TExpected<ui32, TPushClientError> TryClearFile() override { return 1; }
    virtual TMaybe<TPushClientError> HasBecomeInvalid() override { return Nothing(); }
};

} //namespace NInfra::NPodAgent
