#pragma once

#include "file_stream_rotated.h"

namespace NInfra::NPodAgent {

class TMockInvalidFileStreamRotated: public IFileStreamRotated {
public:
    TMockInvalidFileStreamRotated(const TString& filePath, const TPushClientError& invalidCause) 
        : FilePath_(filePath)
        , InvalidCause_(invalidCause)
    {}

    virtual ~TMockInvalidFileStreamRotated() = default;

    virtual TExpected<TString, TPushClientError> Read(ui64, ui64) override { return TExpected<TString, TPushClientError>::DefaultSuccess(); }
    virtual TExpected<ui64, TPushClientError> Rotate() override { return TExpected<ui64, TPushClientError>::DefaultSuccess(); }
    virtual TExpected<ui64, TPushClientError> GetFileSize() const override { return TExpected<ui64, TPushClientError>::DefaultSuccess(); }
    virtual TString GetFilePath() const override { return FilePath_; };
    virtual TExpected<ui32, TPushClientError> TryClearFile() override { return 1; }
    virtual TMaybe<TPushClientError> HasBecomeInvalid() override { return InvalidCause_; }

private:
    TString FilePath_;
    TPushClientError InvalidCause_;
};

} //namespace NInfra::NPodAgent
