#pragma once

#include <infra/pod_agent/libs/push_client/utils/push_client_types.h>
#include <util/generic/hash_set.h>
#include <util/generic/ptr.h>

namespace NInfra::NPodAgent {

class IFilter;
using TFilterPtr = TIntrusivePtr<IFilter>;

class IFilter: public TAtomicRefCount<IFilter> {
public:
    virtual THashSet<TPushContainer> Filter(THashSet<TPushContainer>&& pushContainers) = 0;
    virtual ~IFilter() = default;
};

} //namespace NInfra::NPodAgent
