#include "porto_exists_containers_filter.h"

#include <infra/pod_agent/libs/pod_agent/logs_transmitter/utils/logs_transmitter_utils.h>

namespace NInfra::NPodAgent {

TPortoExistsContainersFilter::TPortoExistsContainersFilter(TPortoClientPtr porto, TLogFramePtr logFrame)
    : Porto_(porto)
    , LogFrame_(logFrame)
{}

THashSet<TPushContainer> TPortoExistsContainersFilter::Filter(THashSet<TPushContainer>&& pushContainers) {
    for (auto containerIt = pushContainers.begin(); containerIt != pushContainers.end();) {
        auto containerItToErase = containerIt++;
        auto existsResult = Porto_->IsContainerExists(containerItToErase->Container);

        if (existsResult) {
            if (!existsResult.Success()) {
                pushContainers.erase(containerItToErase);
            }
        } else {
            LogFrame_->LogEvent(ELogPriority::TLOG_ERR, NLogsTransmitterUtils::ConstructExceptionEvent(existsResult.Error()));
        }

    }

    return pushContainers;
}

} //namespace NInfra::NPodAgent
