#pragma once

#include "filter.h"

#include <infra/libs/logger/log_frame.h>
#include <infra/pod_agent/libs/porto_client/client.h>

namespace NInfra::NPodAgent {

class TPortoExistsContainersFilter;
using TPortoExistsContainersFilterPtr = TIntrusivePtr<TPortoExistsContainersFilter>;

class TPortoExistsContainersFilter: public IFilter {
public:
    TPortoExistsContainersFilter(TPortoClientPtr porto, TLogFramePtr logFrame);
    THashSet<TPushContainer> Filter(THashSet<TPushContainer>&& pushContainers) override;

private:
    TPortoClientPtr Porto_;
    TLogFramePtr LogFrame_;
};

} //namespace NInfra::NPodAgent
