#include "porto_exists_containers_filter.h"

#include <infra/pod_agent/libs/porto_client/mock_client.h>
#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NPortoExistsContainersFilterTest {

static TLogger logger({});
static THashSet<TPushContainer> pushContainers = {
    TPushContainer({TPortoContainerName({"box_1"}, "workload_1"), {"1"}, {"1"}}),
    TPushContainer({TPortoContainerName({"box_2"}, "workload_2"), {"2"}, {"2"}}),
};

struct TTestPortoClient: public TMockPortoClient {
    TExpected<int, TPortoError> IsContainerExists(const TPortoContainerName&) override {
        ++ExistCalls;
        return true;
    }

    size_t ExistCalls = 0;
};

Y_UNIT_TEST_SUITE(PortoExistsContainersFilterSuite) {

    Y_UNIT_TEST(FilterWhenPortoReturnsTrueTest) {
        TPortoClientPtr porto = new TTestPortoClient;
        TFilterPtr filter = new TPortoExistsContainersFilter(porto, logger.SpawnFrame());

        auto tmpContainers = pushContainers;
        tmpContainers = filter->Filter(std::move(tmpContainers));

        UNIT_ASSERT_EQUAL(2, ((TTestPortoClient*)porto.Get())->ExistCalls);
        UNIT_ASSERT_EQUAL(2, tmpContainers.size());
    }

    Y_UNIT_TEST(FilterWhenPortoReturnsErrorTest) {
        struct TTestPortoClientFails: public TTestPortoClient {
            TExpected<int, TPortoError> IsContainerExists(const TPortoContainerName&) override {
                ++ExistCalls;
                return TPortoError{};
            }
        };

        TPortoClientPtr porto = new TTestPortoClientFails;
        TFilterPtr filter = new TPortoExistsContainersFilter(porto, logger.SpawnFrame());

        auto tmpContainers = pushContainers;
        tmpContainers = filter->Filter(std::move(tmpContainers));

        UNIT_ASSERT_EQUAL(2, ((TTestPortoClient*)porto.Get())->ExistCalls);
        UNIT_ASSERT_EQUAL(2, tmpContainers.size());
    }

    Y_UNIT_TEST(FilterWhenPortoReturnsFalseForOneContainerTest) {
        struct TTestPortoClientOneFalse: public TTestPortoClient {
            TExpected<int, TPortoError> IsContainerExists(const TPortoContainerName&) override {
                ++ExistCalls;
                if (ExistCalls == 1) {
                    return false;
                }

                return true;
            }
        };

        TPortoClientPtr porto = new TTestPortoClientOneFalse;
        TFilterPtr filter = new TPortoExistsContainersFilter(porto, logger.SpawnFrame());

        auto tmpContainers = pushContainers;
        tmpContainers = filter->Filter(std::move(tmpContainers));

        UNIT_ASSERT_EQUAL(2, ((TTestPortoClient*)porto.Get())->ExistCalls);
        UNIT_ASSERT_EQUAL(1, tmpContainers.size());
    }

}

} //namespace NInfra::NPodAgent::NPortoExistsContainersFilterTest
