#pragma once

#include "filter.h"

#include <infra/libs/logger/log_frame.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/holders/holders_context.h>

namespace NInfra::NPodAgent {

class TProcessedContainersFilter;
using TProcessedContainersFilterPtr = TIntrusivePtr<TProcessedContainersFilter>;

class TProcessedContainersFilter: public IFilter {
public:
    TProcessedContainersFilter(THoldersContextPtr stdoutHoldersContext, THoldersContextPtr stderrHoldersContext, TLogFramePtr logFrame);
    virtual THashSet<TPushContainer> Filter(THashSet<TPushContainer>&& pushContainers) override;

private:
    TExpected<i32, TPushClientError> IsProcessedContainer(const TPushContainer& pushContainer, THoldersContextPtr holdersContext);

private:
    THoldersContextPtr StdoutHoldersContext_;
    THoldersContextPtr StderrHoldersContext_;
    TLogFramePtr LogFrame_;
};

} //namespace NInfra::NPodAgent
