#pragma once

#include "updatable_holder.h"

#include <infra/pod_agent/libs/pod_agent/logs_transmitter/file_stream/file_stream_rotated_impl.h>

namespace NInfra::NPodAgent {

class IFileStreamHolder;

using TFileStreamHolderPtr = TIntrusivePtr<IFileStreamHolder>;

class IFileStreamHolder: public IUpdatableHolder {
public:
    virtual TExpected<TFileStreamRotatedPtr, TPushClientError> GetFileStream(const TPushContainer& pushContainer) const = 0;
    //returns size of rotated part
    virtual TExpected<ui64, TPushClientError> TryRotate(const TPushContainer& pushContainer) = 0;
    virtual TVector<TPushClientError> FilesBecameInvalid() = 0;

    virtual ~IFileStreamHolder() = default;
};

} //namespace NInfra::NPodAgent
