#pragma once

#include "file_stream_holder.h"

#include <infra/pod_agent/libs/path_util/path_holder.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/file_stream/file_stream_rotated.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/file_stream/file_stream_rotated_factory.h>

namespace NInfra::NPodAgent {

class TFileStreamHolderImpl: public IFileStreamHolder {
public:
    TFileStreamHolderImpl(
        ui32 maxLogsFileSize
        , double minPortionToCut
        , blksize_t fileSystemBlockSize
        , const ELogType& typeOfLog
        , TPathHolderPtr pathHolder
        , TFileStreamRotatedFactoryPtr fileStreamFactory
        , const bool isBoxAgentMode
    );
    void Update(const THashSet<TPushContainer>& pushContainers) override;
    TExpected<ui64, TPushClientError> TryRotate(const TPushContainer& pushContainer) override;
    TExpected<TFileStreamRotatedPtr, TPushClientError> GetFileStream(const TPushContainer& pushContainer) const override;
    TVector<TPushClientError> FilesBecameInvalid() override;

private:
    THashMap<TPushContainer, TFileStreamRotatedPtr> PushContainerToFileStream_;
    ui32 MaxLogsFileSize_;
    double MinPortionToCut_;
    blksize_t FileSystemBlockSize_;
    const ELogType TypeOfLog_;
    TPathHolderPtr PathHolder_;
    TFileStreamRotatedFactoryPtr FileStreamFactory_;
    const bool IsBoxAgentMode_;
};

} //namespace NInfra::NPodAgent
