#include "holders_context.h"

namespace NInfra::NPodAgent {

THoldersContext::THoldersContext(
    TFileStreamHolderPtr fileStreamHodler
    , TLogsFileOffsetHolderPtr logsFileOffsetHolder
    , TSerializableOffsetHolderPtr portoOffsetHolder
)
    : FileStreamHodler_(fileStreamHodler)
    , LogsFileOffsetHoder_(logsFileOffsetHolder)
    , PortoOffsetHolder_(portoOffsetHolder)
{}

TFileStreamHolderPtr THoldersContext::GetFileStreamHolder() const {
    return FileStreamHodler_;
}

TLogsFileOffsetHolderPtr THoldersContext::GetLogsFileOffsetHolder() const {
    return LogsFileOffsetHoder_;
}

TSerializableOffsetHolderPtr THoldersContext::GetPortoOffsetHolder() const {
    return PortoOffsetHolder_;
}

} //namespace NInfra::NPodAgent
