#pragma once

#include "file_stream_holder.h"
#include "logs_file_offset_holder.h"
#include "porto_offset_holder_impl.h"
#include "session_holder.h"

#include <util/generic/ptr.h>

namespace NInfra::NPodAgent {

class THoldersContext;
using THoldersContextPtr = TIntrusivePtr<THoldersContext>;

class THoldersContext: public TAtomicRefCount<THoldersContext> {
public:
    THoldersContext(TFileStreamHolderPtr fileStreamHodler, TLogsFileOffsetHolderPtr logsFileOffsetHolder, TSerializableOffsetHolderPtr portoOffsetHolder);
    TFileStreamHolderPtr GetFileStreamHolder() const;
    TLogsFileOffsetHolderPtr GetLogsFileOffsetHolder() const;
    TSerializableOffsetHolderPtr GetPortoOffsetHolder() const;

private:
    TFileStreamHolderPtr FileStreamHodler_;

    TLogsFileOffsetHolderPtr LogsFileOffsetHoder_;
    TSerializableOffsetHolderPtr PortoOffsetHolder_;
};

} //namespace NInfra::NPodAgent
