#pragma once

#include "updatable_holder.h"

#include <infra/libs/logger/log_frame.h>
#include <infra/pod_agent/libs/path_util/path_holder.h>
#include <util/generic/hash_set.h>

namespace NInfra::NPodAgent {

class THoldersUpdater;
using THoldersUpdaterPtr = TIntrusivePtr<THoldersUpdater>;

class THoldersUpdater: public IUpdatableHolder {
public:
    THoldersUpdater() = default;
    virtual void Update(const THashSet<TPushContainer>& pushContainers) override;
    virtual void AddHolder(TUpdatableHolderPtr updatableHolder);
    virtual ~THoldersUpdater() = default;

private:
    TVector<TUpdatableHolderPtr> UpdatableHolders_;
};

} //namespace NInfra::NPodAgent
