#include "file_stream_holder_mock.h"
#include "holders_updater.h"
#include "logs_file_offset_holder_mock.h"
#include "session_holder_mock.h"

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NHoldersUpdaterTest {

struct TTestSessionHolder : public TMockSessionHolder {
    void Update(const THashSet<TPushContainer>&) override {
        ++UpdateSessionsCalls;
    }

    size_t UpdateSessionsCalls = 0;
};

struct TTestLogsFileOffsetHolder : public TMockLogsFileOffsetHolder {
    void Update(const THashSet<TPushContainer>&) override {
        ++UpdateOffsetsCalls;
    }

    size_t UpdateOffsetsCalls = 0;
};

struct TTestFileStreamHolder: public TMockFileStreamHolder {
    void Update(const THashSet<TPushContainer>&) override {
        ++UpdateFileStreamsCalls;
    }

    size_t UpdateFileStreamsCalls = 0;
};

Y_UNIT_TEST_SUITE(HoldersUpdaterSuite) {

    Y_UNIT_TEST(UpdateOkTest) {
        THoldersUpdaterPtr holdersUpdater = new THoldersUpdater();
        TFileStreamHolderPtr fileStreamHolder = new TTestFileStreamHolder;
        TLogsFileOffsetHolderPtr offsetHolder = new TTestLogsFileOffsetHolder;
        TSessionHolderPtr sessionHolder = new TTestSessionHolder;
        holdersUpdater->AddHolder(fileStreamHolder);
        holdersUpdater->AddHolder(offsetHolder);
        holdersUpdater->AddHolder(sessionHolder);

        THashSet<TPushContainer> pushContainers;

        holdersUpdater->Update(pushContainers);

        UNIT_ASSERT_EQUAL(1, ((TTestLogsFileOffsetHolder*)offsetHolder.Get())->UpdateOffsetsCalls);
        UNIT_ASSERT_EQUAL(1, ((TTestSessionHolder*)sessionHolder.Get())->UpdateSessionsCalls);
        UNIT_ASSERT_EQUAL(1, ((TTestFileStreamHolder*)fileStreamHolder.Get())->UpdateFileStreamsCalls);
    }

}

} //namespace NInfra::NPodAgent::NHoldersUpdaterTest
