#pragma once

#include "serializable_offset_holder.h"

#include <infra/pod_agent/libs/push_client/utils/push_client_types.h>

namespace NInfra::NPodAgent {

class ILogsFileOffsetHolder;
using TLogsFileOffsetHolderPtr = TIntrusivePtr<ILogsFileOffsetHolder>;

class ILogsFileOffsetHolder: public ISerializableOffsetHolder {
public:
    virtual TExpected<void, TPushClientError> DecrementOffset(const TPushContainer& container, ui64 delta) = 0;
    virtual ~ILogsFileOffsetHolder() = default;
};

} //namespace NInfra::NPodAgent
