#include "logs_file_offset_holder_impl.h"
#include "serializable_offset_holder_impl.h"

#include <infra/pod_agent/libs/pod_agent/logs_transmitter/utils/logs_transmitter_utils.h>

#include <util/generic/hash_set.h>
#include <util/system/fs.h>

namespace NInfra::NPodAgent{

TLogsFileOffsetHolder::TLogsFileOffsetHolder(TLogFramePtr logFrame, TLogsTransmitterStatisticsPtr statistics, TSerializableOffsetHolderPtr offsetHolderImpl)
    : LogFrame_(logFrame)
    , Statistics_(statistics)
    , OffsetHolderImpl_(offsetHolderImpl)
{}

void TLogsFileOffsetHolder::Update(const THashSet<TPushContainer>& pushContainers) {
    OffsetHolderImpl_->Update(pushContainers);
}

TExpected<ui64, TPushClientError> TLogsFileOffsetHolder::GetOffset(const TPushContainer& container) const {
    return OffsetHolderImpl_->GetOffset(container);
}

TExpected<void, TPushClientError> TLogsFileOffsetHolder::UpdateOffset(const TPushContainer& container, ui64 offset) {
    return OffsetHolderImpl_->UpdateOffset(container, offset);
}

ui64 TLogsFileOffsetHolder::NumOfOffsets() const {
    return OffsetHolderImpl_->NumOfOffsets();
}

TExpected<void, TPushClientError> TLogsFileOffsetHolder::DecrementOffset(const TPushContainer& container, ui64 delta) {
    ui64 offset = OUTCOME_TRYX(OffsetHolderImpl_->GetOffset(container));
    if (offset < delta) {

        Statistics_->AddNumBytesRotated(delta - offset);

        offset = 0;
        return OffsetHolderImpl_->UpdateOffset(container, offset);
    }

    ui64 newOffset = offset - delta;
    return OffsetHolderImpl_->UpdateOffset(container, newOffset);
}

void TLogsFileOffsetHolder::SerializeAll(TSerializerPtr serializer) const {
    OffsetHolderImpl_->SerializeAll(serializer);
}

void TLogsFileOffsetHolder::Serialize(const THashSet<TPushContainer>& pushContainers, TSerializerPtr serializer) const {
    OffsetHolderImpl_->Serialize(pushContainers, serializer);
}

void TLogsFileOffsetHolder::Deserialize(const THashSet<TPushContainer>& pushContainers, TDeserializerPtr deserializer) {
    OffsetHolderImpl_->Deserialize(pushContainers, deserializer);
}

}
