#pragma once

#include "logs_file_offset_holder.h"

#include <infra/pod_agent/libs/pod_agent/logs_transmitter/statistics/logs_transmitter_statistics.h>
#include <infra/pod_agent/libs/porto_client/client.h>
#include <infra/pod_agent/libs/push_client/utils/push_client_types.h>

namespace NInfra::NPodAgent {

class TLogsFileOffsetHolder;

using TLogsFileOffsetHolderImplPtr = TIntrusivePtr<TLogsFileOffsetHolder>;

class TLogsFileOffsetHolder : public ILogsFileOffsetHolder {
public:
    TLogsFileOffsetHolder(TLogFramePtr logFrame, TLogsTransmitterStatisticsPtr statistics, TSerializableOffsetHolderPtr offsetHolderImpl);
    void Update(const THashSet<TPushContainer>& pushContainers) override;
    TExpected<ui64, TPushClientError> GetOffset(const TPushContainer& container) const override;
    TExpected<void, TPushClientError> UpdateOffset(const TPushContainer& container, ui64 offset) override;
    TExpected<void, TPushClientError> DecrementOffset(const TPushContainer& container, ui64 delta) override;
    ui64 NumOfOffsets() const override;

    void SerializeAll(TSerializerPtr serializer) const override;
    void Serialize(const THashSet<TPushContainer>& pushContainers, TSerializerPtr serializer) const override;
    void Deserialize(const THashSet<TPushContainer>& pushContainers, TDeserializerPtr deserializer) override;

private:
    TLogFramePtr LogFrame_;
    TLogsTransmitterStatisticsPtr Statistics_;
    TSerializableOffsetHolderPtr OffsetHolderImpl_;
};

} //namespace NInfra::NPodAgent
