#pragma once

#include "updatable_holder.h"

#include <infra/pod_agent/libs/push_client/utils/push_client_types.h>

#include <util/generic/hash_set.h>

namespace NInfra::NPodAgent {

class IOffsetHolder;
using TOffsetHolderPtr = TIntrusivePtr<IOffsetHolder>;

class IOffsetHolder: public IUpdatableHolder {
public:
    virtual TExpected<void, TPushClientError> UpdateOffset(const TPushContainer& container, ui64 offset) = 0;
    virtual TExpected<ui64, TPushClientError> GetOffset(const TPushContainer& container) const = 0;
    virtual ui64 NumOfOffsets() const = 0;
    virtual ~IOffsetHolder() = default;
};

} //namespace NInfra::NPodAgent
