#pragma once

#include "serializable_offset_holder.h"
#include "serializable_offset_holder_impl.h"

#include <infra/pod_agent/libs/pod_agent/logs_transmitter/statistics/logs_transmitter_statistics.h>
#include <infra/pod_agent/libs/porto_client/client.h>
#include <infra/pod_agent/libs/push_client/utils/push_client_types.h>

namespace NInfra::NPodAgent {

class TPortoOffsetHolderImpl;
using TPortoOffsetHolderPtr = TIntrusivePtr<TPortoOffsetHolderImpl>;

class TPortoOffsetHolderImpl: public ISerializableOffsetHolder {
public:
    TPortoOffsetHolderImpl(TLogFramePtr logFrame, TLogsTransmitterStatisticsPtr statistics, TSerializableOffsetHolderPtr serializableOffsetHolderImpl);
    void Update(const THashSet<TPushContainer>& pushContainers) override;
    TExpected<ui64, TPushClientError> GetOffset(const TPushContainer& container) const override;
    TExpected<void, TPushClientError> UpdateOffset(const TPushContainer& container, ui64 offset) override;
    ui64 NumOfOffsets() const override;

    void SerializeAll(TSerializerPtr serializer) const override;
    void Serialize(const THashSet<TPushContainer>& pushContainers, TSerializerPtr serializer) const override;
    void Deserialize(const THashSet<TPushContainer>& pushContainers, TDeserializerPtr deserializer) override;

private:
    TLogFramePtr LogFrame_;
    TLogsTransmitterStatisticsPtr Statistics_;
    TSerializableOffsetHolderPtr SerializableOffsetHolderImpl_;
};

} //namespace NInfra::NPodAgent
