#pragma once

#include <infra/pod_agent/libs/pod_agent/logs_transmitter/serialize_utils/deserializer.h>
#include <infra/pod_agent/libs/pod_agent/logs_transmitter/serialize_utils/serializer.h>
#include <infra/pod_agent/libs/push_client/utils/push_client_types.h>

#include <util/generic/hash_set.h>

namespace NInfra::NPodAgent {

class ISerializableHolder {
public:
    virtual void SerializeAll(TSerializerPtr serializer) const = 0;
    virtual void Serialize(const THashSet<TPushContainer>& pushContainers, TSerializerPtr serializer) const = 0;
    //NOTE: for success deserialization pushContainers should be contained in holder !!
    virtual void Deserialize(const THashSet<TPushContainer>& pushContainers, TDeserializerPtr deserializer) = 0;
};

} //namespace NInfra::NPodAgent
