#pragma once

#include "serializable_offset_holder.h"

#include <infra/libs/logger/log_frame.h>

#include <util/generic/hash_set.h>
#include <util/generic/maybe.h>

namespace NInfra::NPodAgent {

struct TOffsetDescription {
    ui64 Offset_;
    ui64 LastSerializedOffset_;
};

class TSerializableOffsetHolder: public ISerializableOffsetHolder {
public:
    TSerializableOffsetHolder(TLogFramePtr logFrame);
    void Update(const THashSet<TPushContainer>& pushContainers) override;
    TExpected<ui64, TPushClientError> GetOffset(const TPushContainer& container) const override;
    TExpected<void, TPushClientError> UpdateOffset(const TPushContainer& container, ui64 offset) override;
    ui64 NumOfOffsets() const override;
    void SerializeAll(TSerializerPtr serializer) const override;
    void Serialize(const THashSet<TPushContainer>& pushContainers, TSerializerPtr serializer) const override;
    void Deserialize(const THashSet<TPushContainer>& pushContainers, TDeserializerPtr deserializer) override;

private:
    void SerializeIfUpdated(const TPushContainer& pushContainer, const TOffsetDescription& offset, TSerializerPtr serializer) const;

private:
    TLogFramePtr LogFrame_;
    mutable THashMap<TPushContainer, TOffsetDescription> ContainerToOffsetDescription_;
};

} //namespace NInfra::NPodAgent
