#pragma once

#include "serializable_offset_holder.h"

namespace NInfra::NPodAgent {

class TMockSerializableOffsetHolder: public ISerializableOffsetHolder {
public:
    virtual void Update(const THashSet<TPushContainer>&) override {}
    virtual TExpected<void, TPushClientError> UpdateOffset(const TPushContainer&, ui64) override { return TExpected<void, TPushClientError>::DefaultSuccess(); }
    virtual TExpected<ui64, TPushClientError> GetOffset(const TPushContainer&) const override { return TExpected<ui64, TPushClientError>::DefaultSuccess(); }
    virtual ui64 NumOfOffsets() const override { return 0; }
    virtual void SerializeAll(TSerializerPtr) const override {}
    virtual void Serialize(const THashSet<TPushContainer>&, TSerializerPtr) const override { }
    virtual void Deserialize(const THashSet<TPushContainer>&, TDeserializerPtr) override {}
};

} //namespace NInfra::NPodAgent

