#pragma once

#include "updatable_holder.h"

#include <infra/libs/outcome/result.h>
#include <infra/pod_agent/libs/push_client/sessions/push_session.h>

namespace NInfra::NPodAgent {

class ISessionHolder;

using TSessionHolderPtr = TIntrusivePtr<ISessionHolder>;

class ISessionHolder: public IUpdatableHolder {
public:
    virtual TExpected<TPushSessionPtr, TPushClientError> GetSession(const TPushContainer& pushContainer) const = 0;
    virtual TExpected<TPushSessionPtr, TPushClientError> ActivateSession(const TPushContainer& pushContainer) = 0;
    virtual TExpected<void, TPushClientError> DeactivateSession(const TPushContainer& pushContainer) = 0;
    virtual TExpected<void, TPushClientError> IncreaseLogSeqNumber(ui32 increaseFactor, const TPushContainer& pushContainer) = 0;
    virtual TExpected<int, TPushClientError> IsActive(const TPushContainer& pushContainer) const = 0;
    virtual size_t NumOfActiveSessions() const = 0;

    virtual ~ISessionHolder() = default;
};

} //namespace NInfra::NPodAgent
