#pragma once

#include "session_holder.h"

#include <infra/pod_agent/libs/pod_agent/logs_transmitter/statistics/logs_transmitter_statistics.h>
#include <infra/pod_agent/libs/push_client/sessions/push_session_factory.h>

namespace NInfra::NPodAgent {

class TSessionHolderImpl;

using TSessionHolderImplPtr = TIntrusivePtr<TSessionHolderImpl>;

class TSessionHolderImpl : public ISessionHolder{
public:
    TSessionHolderImpl(const TString& logName, const ELogType& typeOfLog, TPushSessionFactoryPtr pushSessionFactory, TLogsTransmitterStatisticsPtr statistics);
    void Update(const THashSet<TPushContainer>& pushContainers) override;
    TExpected<TPushSessionPtr, TPushClientError> GetSession(const TPushContainer& pushContainer) const override ;
    TExpected<TPushSessionPtr, TPushClientError> ActivateSession(const TPushContainer& pushContainer) override;
    TExpected<void, TPushClientError> DeactivateSession(const TPushContainer& pushContainer) override;
    TExpected<void, TPushClientError> IncreaseLogSeqNumber(ui32 increaseFactor, const TPushContainer& pushContainer) override;
    TExpected<int, TPushClientError> IsActive(const TPushContainer& pushContainer) const override;
    size_t NumOfActiveSessions() const override;
    size_t NumOfSessions() const;

    const THashMap<TPushContainer, TPushSessionPtr>& GetSessions() const;

private:
    const TString LogName_;
    const ELogType TypeOflog_;
    THashMap<TPushContainer, TPushSessionPtr> PushContainerToSession_;
    TLogsTransmitterStatisticsPtr Statistics_;
    TPushSessionFactoryPtr PushSessionFactory_;
};

} //namespace NInfra::NPodAgent
