#pragma once

#include "session_holder.h"

namespace NInfra::NPodAgent {

class TMockSessionHolder: public ISessionHolder {
public:
    TMockSessionHolder() {}
    virtual void Update(const THashSet<TPushContainer>&) override {}
    virtual TExpected <TPushSessionPtr, TPushClientError> GetSession(const TPushContainer&) const override { return TExpected<TPushSessionPtr, TPushClientError>::DefaultSuccess(); }
    virtual TExpected <TPushSessionPtr, TPushClientError> ActivateSession(const TPushContainer&) override { return TExpected<TPushSessionPtr, TPushClientError>::DefaultSuccess(); }
    virtual TExpected<void, TPushClientError> DeactivateSession(const TPushContainer&) override { return TExpected<void, TPushClientError>::DefaultSuccess(); }
    virtual TExpected<void, TPushClientError> IncreaseLogSeqNumber(ui32, const TPushContainer&) override { return TExpected<void, TPushClientError>::DefaultSuccess(); }
    virtual TExpected<int, TPushClientError> IsActive(const TPushContainer&) const override { return TExpected<int, TPushClientError>::DefaultSuccess(); }
    virtual size_t NumOfActiveSessions() const override { return 0; }
};

} //namespace NInfra::NPodAgent
