#pragma once

#include <infra/pod_agent/libs/push_client/utils/push_client_types.h>
#include <util/generic/ptr.h>

namespace NInfra::NPodAgent {

class IUpdatableHolder;
using TUpdatableHolderPtr = TIntrusivePtr<IUpdatableHolder>;

class IUpdatableHolder: public TAtomicRefCount<IUpdatableHolder> {
public:
    virtual void Update(const THashSet<TPushContainer>& pushContainers) = 0;
    virtual ~IUpdatableHolder() = default;
};

} //namespace NInfra::NPodAgent
